<?php session_start(); ?>
<!DOCTYPE html>
<html>
<head>
<title>Hunger Halt | Admin Login</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<style>
    body {
        font-family: Arial, sans-serif;
        background: linear-gradient(to bottom right, #0f172a, #1e293b);
        display: flex;
        align-items: center;
        justify-content: center;
        height: 100vh;
        margin: 0;
        padding: 15px;
    }

    .login-card {
        width: 100%;
        max-width: 420px;
        background: rgba(255, 255, 255, 0.08);
        backdrop-filter: blur(10px);
        padding: 35px 25px;
        border-radius: 15px;
        color: #fff;
        box-shadow: 0 8px 25px rgba(0,0,0,0.3);
        animation: fadeIn 0.6s ease-in-out;
    }

    @keyframes fadeIn {
        from {opacity: 0; transform: scale(0.95);}
        to {opacity: 1; transform: scale(1);}
    }

    .logo-box {
        text-align: center;
        margin-bottom: 20px;
    }

    .logo-box img {
        width: 80px;
        height: 80px;
        object-fit: contain;
        border-radius: 50%;
    }

    h2 {
        text-align: center;
        margin-bottom: 20px;
    }

    input {
        width: 100%;
        padding: 14px;
        border-radius: 8px;
        border: none;
        margin-bottom: 14px;
        background: rgba(255,255,255,0.15);
        color: white;
        outline: none;
        font-size: 16px;
    }

    input::placeholder {
        color: #cbd5e1;
    }

    button {
        width: 100%;
        padding: 14px;
        background: #22c1c3;
        color: #000;
        font-weight: bold;
        border: none;
        border-radius: 10px;
        cursor: pointer;
        font-size: 16px;
        transition: 0.3s;
    }

    button:hover {
        background: #1ca4a6;
        transform: translateY(-2px);
    }

    .err {
        background: #ff6b6b;
        padding: 12px;
        border-radius: 6px;
        margin-bottom: 15px;
        text-align: center;
        font-weight: bold;
        animation: shake 0.2s;
    }

    @keyframes shake {
        0% { transform: translateX(0); }
        25% { transform: translateX(-3px); }
        50% { transform: translateX(3px); }
        75% { transform: translateX(-3px); }
        100% { transform: translateX(0); }
    }
</style>

</head>
<body>

<div class="login-card">

    <!-- LOGO -->
    <div class="logo-box">
        <img src="assets/logo.png" alt="Logo">
    </div>

    <h2>Admin Login</h2>

    <?php 
    if(isset($_SESSION['err'])){ 
        echo "<div class='err'>".$_SESSION['err']."</div>"; 
        unset($_SESSION['err']); 
    } 
    ?>

    <form method="post" action="process_login.php">
        <input type="email" name="email" placeholder="Admin Email" required>
        <input type="password" name="password" placeholder="Password" required>

        <button type="submit">Login</button>
    </form>

</div>

</body>
</html>
