<?php
session_start();
if(!isset($_SESSION['admin_id'])){
  header('Location: admin_login.php');
  exit;
}
include 'config/db.php';

$states = [
'Abia','Adamawa','Akwa Ibom','Anambra','Bauchi','Bayelsa','Benue','Borno','Cross River','Delta','Ebonyi','Edo','Ekiti','Enugu','Gombe','Imo','Jigawa','Kaduna','Kano','Katsina','Kebbi','Kogi','Kwara','Lagos','Nasarawa','Niger','Ogun','Ondo','Osun','Oyo','Plateau','Rivers','Sokoto','Taraba','Yobe','Zamfara','FCT'
];
?>
<!doctype html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Register Member | Hunger Halt</title>

<style>
*{
  box-sizing:border-box;
  font-family: "Segoe UI", system-ui, sans-serif;
}

body{
  margin:0;
  background:linear-gradient(135deg,#0f766e,#022c22);
  min-height:100vh;
  display:flex;
  align-items:center;
  justify-content:center;
  padding:20px;
}

.card{
  background:#ffffff;
  width:100%;
  max-width:480px;
  border-radius:18px;
  padding:28px;
  box-shadow:0 20px 50px rgba(0,0,0,.25);
}

.card h2{
  margin:0 0 20px;
  text-align:center;
  color:#0f766e;
  font-size:22px;
}

.form-group{
  margin-bottom:16px;
}

.form-group label{
  font-size:14px;
  font-weight:600;
  color:#334155;
  display:block;
  margin-bottom:6px;
}

.form-group input,
.form-group select{
  width:100%;
  padding:12px 14px;
  border:1px solid #cbd5f5;
  border-radius:10px;
  outline:none;
  font-size:14px;
  transition:.2s;
}

.form-group input:focus,
.form-group select:focus{
  border-color:#0f766e;
  box-shadow:0 0 0 3px rgba(15,118,110,.15);
}

.btn{
  width:100%;
  padding:14px;
  border:none;
  border-radius:12px;
  font-size:15px;
  font-weight:600;
  color:#fff;
  background:linear-gradient(135deg,#0f766e,#14b8a6);
  cursor:pointer;
  transition:.2s;
}

.btn:hover{
  transform:translateY(-1px);
  box-shadow:0 10px 20px rgba(20,184,166,.35);
}

.note{
  margin-top:14px;
  text-align:center;
  font-size:13px;
  color:#64748b;
}
</style>
<script>
function checkReferrer() {
    let id = document.getElementById("referrer_id").value;

    if (id.trim() === "") {
        document.getElementById("refName").innerHTML = "";
        return;
    }

    // prevent browser caching by adding random number
    let noCache = Math.random();

    let xhr = new XMLHttpRequest();
    xhr.open("GET", "validate_referrer.php?ref=" + id + "&nocache=" + noCache, true);

    xhr.onload = function() {
        if (this.responseText === "0") {
            document.getElementById("refName").innerHTML =
              "<span style='color:red;font-weight:600'>❌ Invalid Referrer ID</span>";
        } else {
            document.getElementById("refName").innerHTML =
              "<span style='color:green;font-weight:600'>✔ Referrer: " + this.responseText + "</span>";
        }
    };

    xhr.send();
}
</script>

</head>

<body>
<?php include "sidebar.php"; ?>
<div class="card">
  <h2>Register New Member</h2>

  <form method="post" action="initiate_payment.php">

    <div class="form-group">
      <label>Full Name</label>
      <input type="text" name="fullname" required placeholder="Member full name">
    </div>

    <div class="form-group">
      <label>Phone Number (include +234)</label>
      <input type="text" name="phone" required placeholder="+2348012345678">
    </div>

    <div class="form-group">
      <label>Address</label>
      <input type="text" name="address" required placeholder="Residential address">
    </div>

    <div class="form-group">
      <label>Gender</label>
      <select name="gender" required>
        <option value="">-- Select Gender --</option>
        <option value="male">Male</option>
        <option value="female">Female</option>
        <option value="other">Other</option>
      </select>
    </div>

    <div class="form-group">
      <label>State of Origin</label>
      <select name="state" required>
        <option value="">-- Select State --</option>
        <?php foreach($states as $s){ ?>
          <option value="<?= htmlspecialchars($s) ?>">
            <?= htmlspecialchars($s) ?>
          </option>
        <?php } ?>
      </select>
    </div>

    <div class="form-group">
      <label>Referrer ID (optional)</label>
      <input type="text" id="referrer_id" name="referrer_unique_id" placeholder="Example: HHI123456" onkeyup="checkReferrer()">
      <div id="refName" style="margin-top:6px;font-size:13px;"></div>
    </div>

    <button type="submit" class="btn">
      Proceed to Payment (₦8,000)
    </button>

    <div class="note">
      Payment must be completed before registration is finalized.
    </div>

  </form>
</div>

</body>
</html>