<?php
session_start();
include "config/db.php";
include "sidebar.php"; 

$filter_unique = $_GET['unique_id'] ?? "";
$filter_name   = $_GET['name'] ?? "";
$filter_status = $_GET['status'] ?? "";

// FILTER QUERY
$query = "
SELECT r.*, u.fullname, u.unique_id, u.phone
FROM rewards r
JOIN users u ON r.user_id = u.id
WHERE 1
";

if ($filter_unique !== "") {
    $query .= " AND u.unique_id LIKE '%$filter_unique%'";
}

if ($filter_name !== "") {
    $query .= " AND u.fullname LIKE '%$filter_name%'";
}

if ($filter_status !== "") {
    $query .= " AND r.status = '$filter_status'";
}

$query .= " ORDER BY r.id DESC";
$rewards = $conn->query($query);
?>

<!-- ===========================
     PAGE STYLES
=========================== -->
<style>
    body {
        background: #f5f7fb;
        font-family: Arial, Helvetica, sans-serif;
    }

    .main-content {
        margin-left: 260px; /* Prevent sidebar overlap */
        padding: 25px;
    }

    @media(max-width: 768px){
        .main-content {
            margin-left: 0 !important;
            padding: 15px;
        }
    }

    h2 {
        margin-bottom: 15px;
        font-size: 24px;
        font-weight: bold;
        color: #333;
    }

    /* Card */
    .card {
        background: #fff;
        border-radius: 10px;
        padding: 20px;
        margin-bottom: 25px;
        box-shadow: 0 3px 12px rgba(0,0,0,0.08);
    }

    /* Filter Bar */
    .filter-box {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
        margin-bottom: 15px;
    }

    .filter-box input, .filter-box select {
        padding: 10px;
        border: 1px solid #ccc;
        border-radius: 6px;
        flex: 1;
        min-width: 150px;
    }

    .filter-btn {
        background: #4caf50;
        color: white;
        border: none;
        padding: 10px 20px;
        border-radius: 6px;
        cursor: pointer;
    }

    .filter-btn:hover {
        background: #3d8c40;
    }

    /* Table styling */
    .table-responsive {
        overflow-x: auto;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        min-width: 600px;
    }

    table th {
        background: #eef3ff;
        padding: 12px;
        text-align: left;
        font-size: 14px;
    }

    table td {
        padding: 10px;
        border-bottom: 1px solid #ddd;
        font-size: 14px;
    }

    tr:hover {
        background: #f9fbff;
    }

    .btn-claim {
        background: #4caf50;
        color: #fff !important;
        padding: 6px 12px;
        border-radius: 6px;
        text-decoration: none;
        font-size: 13px;
    }

    .btn-claim:hover {
        background: #3e8d41;
    }

    .badge {
        padding: 6px 12px;
        border-radius: 6px;
        font-size: 12px;
    }
    .badge-unclaimed {
        background: #ffe9d6;
        color: #a75a00;
    }
    .badge-claimed {
        background: #d7ffd6;
        color: #0a7d00;
    }
</style>

<!-- ===========================
     PAGE CONTENT
=========================== -->
<div class="main-content">

    <h2>Reward Management</h2>

    <div class="card">

        <!-- FILTER FORM -->
        <form method="GET">
            <div class="filter-box">
                <input type="text" name="unique_id" placeholder="Search Unique ID" value="<?=$filter_unique?>">
                <input type="text" name="name" placeholder="Search Name" value="<?=$filter_name?>">
                
                <select name="status">
                    <option value="">All Status</option>
                    <option value="unclaimed" <?=($filter_status=="unclaimed"?"selected":"")?>>Unclaimed</option>
                    <option value="claimed" <?=($filter_status=="claimed"?"selected":"")?>>Claimed</option>
                </select>

                <button type="submit" class="filter-btn">Filter</button>
            </div>
        </form>

        <!-- TABLE -->
        <div class="table-responsive">
            <table>
                <tr>
                    <th>ID</th>
                    <th>User</th>
                    <th>Reward Amount</th>
                    <th>Status</th>
                    <th>Created</th>
                    <th>Action</th>
                </tr>

                <?php while($r = $rewards->fetch_assoc()): ?>
                <tr>
                    <td><?=$r['id']?></td>

                    <td>
                        <strong><?=$r['fullname']?></strong><br>
                        <small><?=$r['unique_id']?></small>
                    </td>

                    <td>₦<?=number_format($r['amount'],2)?></td>

                    <td>
                        <?php if ($r['status']=="unclaimed"): ?>
                            <span class="badge badge-unclaimed">Unclaimed</span>
                        <?php else: ?>
                            <span class="badge badge-claimed">Claimed</span>
                        <?php endif; ?>
                    </td>

                    <td><?=$r['created_at']?></td>

                    <td>
                        <?php if ($r['status']=="unclaimed"): ?>
                            <a href="claim_reward.php?id=<?=$r['id']?>" class="btn-claim">Claim</a>
                        <?php else: ?>
                            <span style="color:gray;">—</span>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endwhile; ?>

            </table>
        </div>

    </div>

</div>
