<?php
session_start();
include "config/db.php";

$search_unique = $_GET['unique_id'] ?? "";
$search_name   = $_GET['name'] ?? "";

// FILTER QUERY
$query = "SELECT * FROM users WHERE 1 ";

if ($search_unique !== "") {
    $query .= " AND unique_id LIKE '%$search_unique%'";
}

if ($search_name !== "") {
    $query .= " AND fullname LIKE '%$search_name%'";
}

$query .= " ORDER BY id DESC";

$users = $conn->query($query);
?>

<?php include "sidebar.php"; ?>

<style>
/* MAIN CONTENT */
.main-content {
    margin-left: 260px; 
    padding: 25px;
    background: #f1f5f9;
    min-height: 100vh;
}

@media(max-width: 768px){
    .main-content {
        margin-left: 0;
        padding: 15px;
    }
}

/* FILTER BOX */
.filter-box {
    background: #fff;
    padding: 15px;
    border-radius: 12px;
    margin-bottom: 20px;
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
    box-shadow: 0 6px 20px rgba(0,0,0,0.08);
}

.filter-box input, .filter-box button {
    padding: 10px 12px;
    border-radius: 8px;
    border: 1px solid #cbd5e1;
    font-size: 14px;
}

.filter-box input {
    width: 100%;
    max-width: 220px;
}

.filter-box button {
    background: #0f766e;
    color: #fff;
    cursor: pointer;
    border: none;
}

.filter-box button:hover {
    background: #14b8a6;
}

/* PAGE TITLE */
h2 {
    margin-top: 0;
    color: #0f766e;
    font-size: 24px;
    font-weight: 700;
    margin-bottom: 20px;
}

/* TABLE WRAPPER */
.table-container {
    background: #fff;
    padding: 18px;
    border-radius: 12px;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    overflow-x: auto;
}

/* TABLE */
table {
    width: 100%;
    border-collapse: collapse;
    min-width: 650px;
}

table th {
    background: #0f766e;
    color: #fff;
    padding: 12px;
    text-align: left;
    font-size: 14px;
}

table td {
    padding: 12px;
    background: #fff;
    border-bottom: 1px solid #e2e8f0;
}

.view-btn {
    padding: 7px 12px;
    background: #0f766e;
    color: #fff;
    text-decoration: none;
    border-radius: 8px;
    font-size: 13px;
    transition: 0.2s;
}

.view-btn:hover {
    background: #14b8a6;
}

@media(max-width: 600px) {
    th, td {
        font-size: 13px;
        padding: 10px;
    }
    h2 {
        font-size: 20px;
    }
}
</style>


<div class="main-content">

<h2>Registered Users</h2>

<!-- FILTER SECTION -->
<form class="filter-box" method="GET">
    <input type="text" name="unique_id" placeholder="Search Unique ID" value="<?= $search_unique ?>">
    <input type="text" name="name" placeholder="Search Name" value="<?= $search_name ?>">

    <button type="submit">Search</button>

    <!-- RESET BUTTON -->
    <a href="admin_users.php" style="
        padding:10px 12px;
        background:#ef4444;
        color:#fff;
        text-decoration:none;
        border-radius:8px;
        font-size:14px;
        display:inline-block;
        text-align:center;
    ">Reset</a>
</form>


<!-- USERS TABLE -->
<div class="table-container">
<table>
    <tr>
        <th>Unique ID</th>
        <th>Name</th>
        <th>Phone</th>
        <th>Wallet</th>
        <th>Action</th>
    </tr>

    <?php while($u = $users->fetch_assoc()): ?>
    <tr>
        <td><?= $u['unique_id'] ?></td>
        <td><?= $u['fullname'] ?></td>
        <td><?= $u['phone'] ?></td>
        <td>₦<?= number_format($u['wallet_balance'],2) ?></td>

        <td>
            <a href="user_profile.php?id=<?= $u['id'] ?>" class="view-btn">
                View Profile
            </a>
        </td>
    </tr>
    <?php endwhile; ?>
</table>
</div>

</div>
