<?php
include "config/db.php";
include "helper.php";

if (!isset($_GET['id'])) {
    die("Invalid Request");
}

$reward_id = $_GET['id'];

// Fetch reward
$q = $conn->prepare("SELECT r.*, u.fullname, u.phone FROM rewards r JOIN users u ON r.user_id=u.id WHERE r.id=? LIMIT 1");
$q->bind_param("i", $reward_id);
$q->execute();
$reward = $q->get_result()->fetch_assoc();

if (!$reward) {
    die("Reward not found.");
}

if ($reward['status'] == "claimed") {
    die("Reward already claimed.");
}

// Mark as claimed
$upd = $conn->prepare("UPDATE rewards SET status='claimed', claimed_at=NOW() WHERE id=?");
$upd->bind_param("i", $reward_id);
$upd->execute();

// Send SMS
$api = "TLXWSEpVugVSerfbaTUgZVslMiOsFEogJRQyLxFkSvsKJpNYsUGgwCuotmxbAP";

$msg = "Hello {$reward['fullname']}, your reward of ₦".number_format($reward['amount'],2).
       " has been claimed on ".date("Y-m-d H:i").".";

send_sms_termii($api, $reward['phone'], $msg);

header("Location: admin_rewards.php?msg=Reward Claimed Successfully");
exit;
?>
