<?php
error_reporting(E_ALL);
ini_set("display_errors", 1);

include "config/db.php";
include "helper.php";

// ---------------------------------------------
// GET QUALIFIED USERS
// ---------------------------------------------
$sql = "
SELECT u.*, 
       (SELECT COUNT(*) FROM users WHERE referred_by = u.id) AS direct_count
FROM users u
HAVING direct_count >= 3 AND wallet_balance >= 15000
";

$result = $conn->query($sql);
if (!$result || $result->num_rows == 0) {
    die("No qualified users for deduction.");
}

$termii_api_key = "TLXWSEpVugVSerfbaTUgZVslMiOsFEogJRQyLxFkSvsKJpNYsUGgwCuotmxbAP";

while ($u = $result->fetch_assoc()) {

    $user_id  = $u['id'];
    $fullname = $u['fullname'];
    $phone    = $u['phone'];
    $referrer = $u['referred_by'];
    $old_balance = $u['wallet_balance'];

    // ---------------------------------------------
    // Deduct ₦8,000
    // ---------------------------------------------
    $deduct_amount = 8000;

    // New remaining balance after deduction
    $remaining = $old_balance - $deduct_amount;

    // Ensure remaining is never negative
    if ($remaining < 0) { 
        $remaining = 0; 
    }

    // Update wallet: first deduct 8000
    $conn->query("UPDATE users SET wallet_balance = wallet_balance - $deduct_amount WHERE id = $user_id");

    // Transaction record
    $conn->query("
        INSERT INTO transactions (user_id,type,amount,description)
        VALUES ($user_id,'auto_deduction',$deduct_amount,'Recurring deduction')
    ");

    // ---------------------------------------------
    // Commission Distribution (same as before)
    // ---------------------------------------------
    if (!empty($referrer)) {
        distribute_commissions($conn, $user_id, $referrer, $deduct_amount);
    }

    // ---------------------------------------------
    // MOVE REMAINING BALANCE TO reward TABLE
    // ---------------------------------------------
    $stmt = $conn->prepare("
        INSERT INTO rewards (user_id, amount, status)
        VALUES (?, ?, 'unclaimed')
    ");
    $stmt->bind_param("id", $user_id, $remaining);
    $stmt->execute();

    // ---------------------------------------------
    // SET WALLET BALANCE TO ZERO
    // ---------------------------------------------
    $conn->query("UPDATE users SET wallet_balance = 0 WHERE id = $user_id");

    // ---------------------------------------------
    // SEND SMS TO USER
    // ---------------------------------------------
    $sms_message = 
        "Hello $fullname, ₦8,000 has been deducted for the Hunger Halt monthly cycle. " .
        "Your remaining balance ₦" . number_format($remaining,2) . " has been moved to reward. Kindly login to claim.";

    send_sms_termii($termii_api_key, $phone, $sms_message);
}

echo "Auto deduction + reward transfer completed successfully.";
?>
