<?php
session_start();
if(!isset($_SESSION['admin_id'])){
  header("location: admin_login.php");
  exit;
}

include "config/db.php";

/* ======================
   DASHBOARD STATISTICS
====================== */

// Total Members
$tm = $conn->query("SELECT COUNT(*) AS total FROM users");
$total_members = $tm->fetch_assoc()['total'] ?? 0;

// Total Wallet Balance
$tw = $conn->query("SELECT SUM(wallet_balance) AS total FROM users");
$total_wallets = $tw->fetch_assoc()['total'] ?? 0;

// Total Commissions Paid
$tc = $conn->query("SELECT SUM(amount) AS total FROM transactions WHERE type='commission'");
$total_commissions = $tc->fetch_assoc()['total'] ?? 0;

// Today's Registrations
$today = date('Y-m-d');
$tr = $conn->query("SELECT COUNT(*) AS total FROM users WHERE DATE(created_at) = '$today'");
$today_regs = $tr->fetch_assoc()['total'] ?? 0;
?>
<!DOCTYPE html>
<html>
<head>
<title>Admin Dashboard | Hunger Halt</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<style>
body{margin:0;font-family:Segoe UI,Arial;background:#f3f4f6}

.top{
background:#0f172a;
color:#fff;
padding:15px 20px;
border-radius:12px;
margin-bottom:20px;
display:flex;
justify-content:space-between;
align-items:center;
}

.menu-btn{
display:none;
font-size:22px;
background:#020617;
color:#fff;
border:none;
padding:10px 14px;
border-radius:10px
}

.main-content{
margin-left:260px;
padding:20px;
min-height:100vh;
}

.stats{
display:grid;
grid-template-columns:repeat(auto-fit,minmax(220px,1fr));
gap:20px;
margin-bottom:30px;
}

.card{
background:#fff;
border-radius:16px;
padding:20px;
box-shadow:0 10px 25px rgba(0,0,0,.08);
}

.card h3{margin:0 0 6px;color:#64748b;font-size:14px}
.card p{margin:0;font-size:24px;font-weight:700;color:#0f766e}

.recent{
background:#fff;
border-radius:16px;
padding:20px;
box-shadow:0 10px 25px rgba(0,0,0,.08);
}

.recent table{
width:100%;
border-collapse:collapse;
font-size:14px;
}

.recent th,.recent td{
padding:10px;
border-bottom:1px solid #e5e7eb;
text-align:left;
}

.recent th{color:#64748b}

/* Mobile */
@media(max-width:900px){
.main-content{margin-left:0}
.menu-btn{display:block}
}
</style>
</head>

<body>

<?php include "sidebar.php"; ?>

<button class="menu-btn" onclick="toggleSidebar()">☰</button>

<div class="main-content">

  <div class="top">
    <div>Welcome, <b><?= htmlspecialchars($_SESSION['admin_name']) ?></b></div>
    <div><a href="logout.php" style="color:#f87171;text-decoration:none">Logout</a></div>
  </div>

  <!-- STATS -->
  <div class="stats">

    <div class="card">
      <h3>Total Members</h3>
      <p><?= number_format($total_members) ?></p>
    </div>

    <div class="card">
      <h3>Total Wallet Balance</h3>
      <p>₦<?= number_format($total_wallets,2) ?></p>
    </div>

    <div class="card">
      <h3>Total Commissions Paid</h3>
      <p>₦<?= number_format($total_commissions,2) ?></p>
    </div>

    <div class="card">
      <h3>Today’s Registrations</h3>
      <p><?= number_format($today_regs) ?></p>
    </div>

  </div>

  <!-- RECENT MEMBERS -->
  <div class="recent">
    <h3 style="margin-bottom:12px">Recent Members</h3>

    <table>
      <tr>
        <th>Name</th>
        <th>Phone</th>
        <th>Wallet</th>
        <th>Date</th>
      </tr>

      <?php
      $recent = $conn->query("SELECT fullname, phone, wallet_balance, created_at FROM users ORDER BY id DESC LIMIT 5");
      while($row = $recent->fetch_assoc()){
      ?>
      <tr>
        <td><?= htmlspecialchars($row['fullname']) ?></td>
        <td><?= htmlspecialchars($row['phone']) ?></td>
        <td>₦<?= number_format($row['wallet_balance'],2) ?></td>
        <td><?= date("d M Y", strtotime($row['created_at'])) ?></td>
      </tr>
      <?php } ?>
    </table>
  </div>

</div>

<script>
function toggleSidebar(){
  document.getElementById('sidebar').classList.toggle('open');
}
</script>

</body>
</html>
