<?php

/* ============================
   GENERATE TX REF
============================ */
function generate_tx_ref(){
    return "HHI-" . time() . "-" . rand(1000,9999);
}

/* ============================
   GENERATE USER ID
============================ */
function generate_user_id(){
    return "HHI/" . date("y") . "/" . strtoupper(uniqid());
}

/* ============================
   DISTRIBUTE COMMISSIONS
============================ */
function distribute_commissions($conn, $new_user_id, $referrer_id, $amount = 8000.0){

    $levels = [1 => 0.70, 2 => 0.20, 3 => 0.10];
    $current = $referrer_id;
    $level   = 1;

    while($current && $level <= 3){

        $commission = $amount * $levels[$level];

        $u = $conn->prepare("UPDATE users SET wallet_balance = wallet_balance + ? WHERE id = ?");
        $u->bind_param("di", $commission, $current);
        $u->execute();

        $t = "commission";
        $desc = "Level {$level} commission from new user ID: {$new_user_id}";
        $ins = $conn->prepare("INSERT INTO transactions (user_id,type,amount,level,description)
                               VALUES (?,?,?,?,?)");
        $ins->bind_param("isdis", $current, $t, $commission, $level, $desc);
        $ins->execute();

        $q = $conn->prepare("SELECT referred_by FROM users WHERE id = ? LIMIT 1");
        $q->bind_param("i", $current);
        $q->execute();
        $res = $q->get_result();

        if($res && $res->num_rows){
            $row = $res->fetch_assoc();
            $current = $row['referred_by'];
        } else {
            $current = null;
        }

        $level++;
    }
}


/* ============================
   ✅ SEND SMS VIA TERMII (FIXED)
============================ */
function send_sms_termii($api_key, $phone, $message){

    // ✅ Format Nigerian number properly
    $phone = trim($phone);
    $phone = ltrim($phone, "+");

    if(substr($phone, 0, 1) === "0"){
        $phone = "234" . substr($phone, 1);
    }

    $payload = json_encode([
        "to" => $phone,
        "from" => "Hunger Halt",   // ✅ YOUR APPROVED SENDER ID
        "sms"  => $message,
        "type" => "plain",
        "channel" => "generic",
        "api_key" => $api_key
    ]);

    $ch = curl_init("https://api.ng.termii.com/api/sms/send");
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json"]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);

    $resp = curl_exec($ch);

    if(curl_errno($ch)){
        return [
            "status" => "error",
            "message" => curl_error($ch)
        ];
    }

    curl_close($ch);

    return json_decode($resp, true);
}
?>
