<?php
session_start();
include "config/db.php";

if($_SERVER['REQUEST_METHOD'] === 'POST'){

    $fullname = trim($_POST['fullname']);
    $phone    = trim($_POST['phone']);
    $address  = trim($_POST['address']);
    $gender   = $_POST['gender'];
    $state    = $_POST['state'];

    // ✅ UNIQUE REFERRAL ID FROM FORM (HHIxxxxxx)
    $referrer_unique_id = trim($_POST['referrer_unique_id'] ?? "");

    $amount = 8000;
    $tx_ref = uniqid("HHI_");

    /* ================================
       ✅ CONVERT UNIQUE REFERRAL → USER ID
    ================================= */
    $referrer_id = null;

    if(!empty($referrer_unique_id)){
        $chkRef = $conn->prepare("SELECT id FROM users WHERE unique_id = ? LIMIT 1");
        $chkRef->bind_param("s", $referrer_unique_id);
        $chkRef->execute();
        $resRef = $chkRef->get_result();

        if($resRef->num_rows == 0){
            die("<script>
                alert('Invalid Referrer ID! Please check and try again.');
                window.location='admin_register.php';
            </script>");
        }

        $rowRef = $resRef->fetch_assoc();
        $referrer_id = $rowRef['id'];   // ✅ INTERNAL NUMERIC ID
    }

    /* ================================
       ✅ CHECK IF PHONE EXISTS (USERS)
    ================================= */
    $chk1 = $conn->prepare("SELECT id FROM users WHERE phone = ? LIMIT 1");
    $chk1->bind_param("s", $phone);
    $chk1->execute();
    $chk1->store_result();

    if($chk1->num_rows > 0){
        die("<script>
            alert('This phone number is already registered!');
            window.location='admin_register.php';
        </script>");
    }

    /* ================================
       ✅ CHECK IF PHONE EXISTS (PENDING)
    ================================= */
    $chk2 = $conn->prepare("SELECT id FROM pending_registrations WHERE phone = ? LIMIT 1");
    $chk2->bind_param("s", $phone);
    $chk2->execute();
    $chk2->store_result();

    if($chk2->num_rows > 0){
        die("<script>
            alert('This phone number already has a pending payment!');
            window.location='admin_register.php';
        </script>");
    }

    /* ================================
       ✅ SAVE TO PENDING REGISTRATIONS
    ================================= */
    $ins = $conn->prepare("
        INSERT INTO pending_registrations
        (tx_ref, fullname, phone, address, gender, state, referrer_id, amount)
        VALUES (?,?,?,?,?,?,?,?)
    ");

    $ins->bind_param(
        "sssssssd",
        $tx_ref,
        $fullname,
        $phone,
        $address,
        $gender,
        $state,
        $referrer_id,
        $amount
    );

    $ins->execute();

    /* ================================
       ✅ FLUTTERWAVE CONFIG
    ================================= */
    $publicKey   = "FLWPUBK_TEST-ba6ef3416a477c15b3cd2aa4d871c3b2-X"; // 🔴 replace live
    $currency    = "NGN";
    $customer_email = "noreply@hungerhalt.org";
    $callback_url   = "http://localhost/hhi/verify_payment.php";
?>
<!doctype html>
<html>
<head>
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Pay with Flutterwave</title>
</head>
<body>

<h3>Redirecting to payment...</h3>

<script src="https://checkout.flutterwave.com/v3.js"></script>
<script>
FlutterwaveCheckout({
    public_key: "<?php echo $publicKey; ?>",
    tx_ref: "<?php echo $tx_ref; ?>",
    amount: <?php echo $amount; ?>,
    currency: "NGN",
    country: "NG",
    payment_options: "card,ussd,banktransfer",

    customer: {
        email: "<?php echo $customer_email; ?>",
        phonenumber: "<?php echo $phone; ?>",
        name: "<?php echo addslashes($fullname); ?>"
    },

    customizations: {
        title: "Hunger Halt Initiative",
        description: "Member registration fee"
    },

    callback: function (data) {
        window.location =
        "<?php echo $callback_url; ?>?transaction_id=" + data.transaction_id +
        "&tx_ref=" + data.tx_ref;
    },

    onclose: function() {
        alert("Payment popup closed");
        window.location = "admin_register.php";
    }
});
</script>

</body>
</html>
<?php
exit;
}
?>
