<?php
if(!isset($_SESSION['admin_id'])){
  header("location: admin_login.php");
  exit;
}
?>

<!-- ===== SIDEBAR STYLES ===== -->
<style>
:root{
    --brand:#0f766e;
    --bg:#0f172a;
    --text:#e5e7eb;
    --muted:#94a3b8;
    --card:#020617;
}

/* WRAPPER FOR MOBILE */
.sidebar-wrapper {
    position: fixed;
    top: 0;
    left: 0;
    height: 100vh;
    width: 260px;
    transform: translateX(0);
    transition: 0.3s ease-in-out;
    z-index: 2000;
}

/* SIDEBAR */
.sidebar{
    height:100%;
    width:100%;
    background:#020617;
    color:var(--text);
    box-shadow:0 20px 50px rgba(0,0,0,.4);
    display:flex;
    flex-direction:column;
}

.sidebar .brand{
    padding:20px;
    border-bottom:1px solid rgba(148,163,184,.15);
    display:flex;align-items:center;gap:12px
}

.sidebar .brand .logo{
    width:40px;height:40px;border-radius:12px;
    background:var(--brand);
    display:grid;place-items:center;
    color:#fff;font-weight:800;font-size:18px;
}

.sidebar .brand h2{
    font-size:18px;
    margin:0;
}

.sidebar nav{
    padding:14px;
    flex:1;
    overflow-y:auto;
}

.sidebar a{
    display:flex;
    align-items:center;
    gap:10px;
    padding:12px 14px;
    border-radius:12px;
    color:var(--text);
    text-decoration:none;
    margin-bottom:8px;
    transition:.2s;
}

.sidebar a:hover,
.sidebar a.active{
    background:rgba(15,118,110,.35);
}

.sidebar .logout{
    padding:14px;
}

.sidebar .logout a{
    background:rgba(239,68,68,.20);
}

/* ===== MOBILE MENU TOGGLE ===== */
.menu-btn{
    position:fixed;
    top:15px;
    left:15px;
    z-index:3000;
    background:var(--brand);
    padding:10px 14px;
    color:white;
    border-radius:8px;
    font-size:18px;
    cursor:pointer;
    display:none;
}

/* MOBILE: sidebar hidden by default */
@media(max-width:768px){
    .menu-btn{
        display:block;
    }
    .sidebar-wrapper{
        transform:translateX(-100%);
    }
    .sidebar-wrapper.active{
        transform:translateX(0);
    }
}

/* DARK OVERLAY WHEN MENU OPENS */
#overlay{
    position:fixed;
    top:0;left:0;
    width:100%;height:100vh;
    background:rgba(0,0,0,0.55);
    backdrop-filter: blur(2px);
    z-index:1500;
    display:none;
}
#overlay.active{
    display:block;
}
</style>

<!-- ===== MOBILE MENU BUTTON ===== -->
<div class="menu-btn" id="menuBtn">☰</div>

<!-- ===== OVERLAY ===== -->
<div id="overlay"></div>

<!-- ===== SIDEBAR WRAPPER ===== -->
<div class="sidebar-wrapper" id="sidebarWrapper">

    <div class="sidebar">
        
        <div class="brand">
            <div class="logo">HHI</div>
            <div>
                <h2>Hunger Halt</h2>
                <small>Admin Panel</small>
            </div>
        </div>

        <nav>
            <a href="dashboard.php">🏠 Dashboard</a>
            <a href="admin_register.php">👤 Register User</a>
            <a href="admin_users.php">👥 All Members</a>
            <a href="admin_rewards.php">💰 Rewards</a>
            <a href="transactions.php">💳 Transactions</a>
            <a href="wallets.php">💰 Wallets</a>
            <a href="sms_logs.php">📨 SMS Logs</a>
            <a href="settings.php">⚙️ Settings</a>
        </nav>

        <div class="logout">
            <a href="logout.php">🚪 Logout</a>
        </div>

    </div>

</div>

<!-- ===== SIDEBAR JS ===== -->
<script>
document.getElementById("menuBtn").addEventListener("click", function(){
    document.getElementById("sidebarWrapper").classList.add("active");
    document.getElementById("overlay").classList.add("active");
});

document.getElementById("overlay").addEventListener("click", function(){
    document.getElementById("sidebarWrapper").classList.remove("active");
    document.getElementById("overlay").classList.remove("active");
});
</script>
