<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

include "config/db.php";     // ✅ REQUIRED
include "helper.php";       // ✅ REQUIRED (for commissions & SMS)

if (!isset($_GET['transaction_id']) || !isset($_GET['tx_ref'])) {
    die("Invalid payment verification.");
}

$transaction_id = $_GET['transaction_id'];
$tx_ref = $_GET['tx_ref'];

// ✅ Flutterwave Secret Key
$secretKey = "FLWSECK_TEST-4469398ba011e72cc8c4385f0ccb5e3d-X";   // 🔴 REPLACE WITH REAL SECRET KEY

// ✅ Verify Payment with Flutterwave
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => "https://api.flutterwave.com/v3/transactions/$transaction_id/verify",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
        "Content-Type: application/json",
        "Authorization: Bearer $secretKey"
    ]
]);

$response = curl_exec($curl);
curl_close($curl);

$result = json_decode($response, true);

if (!$result || $result['status'] !== "success") {
    die("Payment verification failed.");
}

$paid_amount = $result['data']['amount'];

// ✅ Get Pending Registration
$q = $conn->prepare("SELECT * FROM pending_registrations WHERE tx_ref = ? LIMIT 1");
$q->bind_param("s", $tx_ref);
$q->execute();
$res = $q->get_result();

if ($res->num_rows == 0) {
    die("No pending registration found.");
}

$pending = $res->fetch_assoc();

// ✅ Generate Unique Member ID
$unique_id = "HHI" . rand(100000, 999999);

// ✅ Create User Account
$u = $conn->prepare("
    INSERT INTO users (unique_id, fullname, phone, address, gender, state, referred_by, wallet_balance)
    VALUES (?,?,?,?,?,?,?,0)
");

$u->bind_param(
    "ssssssi",
    $unique_id,
    $pending['fullname'],
    $pending['phone'],
    $pending['address'],
    $pending['gender'],
    $pending['state'],
    $pending['referrer_id']
);

$u->execute();
$new_user_id = $conn->insert_id;

// ✅ Record Registration Transaction
$ins2 = $conn->prepare("
    INSERT INTO transactions (user_id, type, amount, description)
    VALUES (?,?,?,?)
");

$t = "registration";
$desc = "Registration fee paid via Flutterwave";

$ins2->bind_param("isds", $new_user_id, $t, $paid_amount, $desc);
$ins2->execute();

// ✅ Distribute Commissions
if (!empty($pending['referrer_id'])) {
    distribute_commissions($conn, $new_user_id, $pending['referrer_id'], floatval($paid_amount));
}

// ✅ Remove Pending Record
$d = $conn->prepare("DELETE FROM pending_registrations WHERE id = ?");
$d->bind_param("i", $pending['id']);
$d->execute();

// ✅ SEND SMS WITH TERMII (Nigeria)
$termii_api_key = "TLXWSEpVugVSerfbaTUgZVslMiOsFEogJRQyLxFkSvsKJpNYsUGgwCuotmxbAP";  // 🔴 Replace
$msg = "Congratulations {$pending['fullname']}! You are now a registered member of Hunger Halt Initiative. Your Member ID is {$unique_id}. Welcome on board!";
$to = ltrim($pending['phone'], "+");

$sms_resp = send_sms_termii($termii_api_key, $to, $msg);


// ✅ SUCCESS PAGE
?>
<!doctype html>
<html>
<head>
<title>Registration Successful</title>
<meta name="viewport" content="width=device-width,initial-scale=1">
<style>
body{font-family:Arial;background:#f0fdf4;text-align:center;padding:40px}
.card{max-width:420px;margin:auto;background:#fff;padding:25px;border-radius:15px;box-shadow:0 10px 25px rgba(0,0,0,.1)}
h2{color:#16a34a}
.id{font-size:20px;font-weight:bold;color:#020617}
a{display:inline-block;margin-top:15px;padding:10px 18px;background:#0f766e;color:#fff;text-decoration:none;border-radius:10px}
</style>
</head>
<body>

<div class="card">
<h2>✅ Registration Successful</h2>
<p>Member Name: <strong><?=htmlspecialchars($pending['fullname'])?></strong></p>
<p>Unique Member ID:</p>
<p class="id"><?=htmlspecialchars($unique_id)?></p>

<p>✅ Commissions distributed to uplines</p>
<p>✅ SMS sent to member</p>

<a href="admin_register.php">Register Another Member</a>
</div>

</body>
</html>
